/************************************************************************
 * NAME:	fileio.h()
 *
 * DESCR:	definitions and structures for fileio in ADOS.
 *
 * NOTES:	
 ************************************************************************/

struct ados_file {
    struct adosfs	*adosfs;
    int			 inuse;		/* TRUE if file handle is being used	*/
    ados_file_entry	*entry;		/* pointer to the actual file entry	*/
    ados_ts_ref		 ts;		/* current track/sector pointer sector	*/
    ados_ts_ref		 cursect;	/* current sector we're working on	*/
    ados_tslist		*tslist;	/* the current track/sector list	*/
    unsigned char	*buffer;	/* storage for sector data		*/
    int			 bufsize;
    int			 cursor;	/* byte position within buffer		*/
                                        /* points to NEXT byte to be consumed	*/
    int			 cursize;
    int			 writemode;	/* TRUE if writing, FALSE otherwise	*/
    int			 sector_count;	/* keeps track of sectors read/written	*/
    int			 last_bytes;	/* number of bytes in last sector	*/
    int			 tslist_offset;	/* latest sector offset from file entry	*/
};

struct ados_statbuf {
    int			ts_blocks;	/* number of track/sector blocks used	*/
    int			blocks;		/* real blocks in file			*/
    int			length;		/* actual length of file		*/
    int			start;		/* starting address for binary files	*/
    ados_file_type	type;		/* file type				*/
};

int ados_fileio_init(struct adosfs *, int);
struct ados_file *ados_file_open(struct adosfs *, char *);
int ados_file_del(struct adosfs *, char *);
void ados_file_close(struct ados_file *);
int ados_file_flush(struct ados_file *);
struct ados_file *ados_file_new(struct adosfs *, char *);
char *ados_filename_translate_in(char *, ados_file_type *);
char *ados_filename_translate_out(char *, ados_file_type);
